% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{predictions_list_runs}
\alias{predictions_list_runs}
\title{List runs for the given prediction}
\usage{
predictions_list_runs(id, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{id}{integer required. The ID of the prediction.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the prediction run.}
\item{predictionId}{integer, The ID of the prediction.}
\item{state}{string, The state of the prediction run.}
\item{exception}{string, The exception, if any, returned by the prediction run.}
\item{name}{string, The name of table created by this predictions run.}
\item{createdAt}{string, The time when the table with created predictions was created.}
\item{scoreStats}{array, An array containing the following fields: 
\itemize{
\item scoreName string, The name of the score.
\item histogram array, The histogram of the distribution of scores.
\item avgScore number, The average score.
\item minScore number, The minimum score.
\item maxScore number, The maximum score.
}}
}
\description{
List runs for the given prediction
}
