% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{dot_plot}
\alias{dot_plot}
\title{dot_plot}
\usage{
dot_plot(results, fdr.cutoff = 0.1, filter.pathways = FALSE)
}
\arguments{
\item{results}{cinaR result object}

\item{fdr.cutoff}{Pathways with smaller fdr values than the cut-off
will be shown as dots.}

\item{filter.pathways}{logical, it will filter the pathways from dot plot
with fdr values less than `fdr.cutoff`.}
}
\value{
ggplot object
}
\description{
Given the results from `cinaR` it produces dot plots for enrichment analyses.
}
\examples{
\donttest{
library(cinaR)
data(atac_seq_consensus_bm) # calls 'bed'

# a vector for comparing the examples
contrasts <- sapply(strsplit(colnames(bed), split = "-", fixed = TRUE),
                    function(x){x[1]})[4:25]

results <- cinaR(bed, contrasts, reference.genome = "mm10")

dot_plot(results)
}
}
