% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_xifti.R
\name{transform_xifti}
\alias{transform_xifti}
\alias{+.xifti}
\alias{-.xifti}
\alias{*.xifti}
\alias{^.xifti}
\alias{>.xifti}
\alias{>=.xifti}
\alias{<.xifti}
\alias{<=.xifti}
\alias{==.xifti}
\alias{!=.xifti}
\alias{\%\%.xifti}
\alias{\%/\%.xifti}
\alias{/.xifti}
\alias{abs.xifti}
\alias{sign.xifti}
\alias{sqrt.xifti}
\alias{floor.xifti}
\alias{ceiling.xifti}
\alias{round.xifti}
\alias{exp.xifti}
\alias{log.xifti}
\title{Apply a univariate transformation to a \code{"xifti"} or pair of \code{"xifti"}s.}
\usage{
transform_xifti(xifti, FUN, xifti2 = NULL, ...)

\method{+}{xifti}(xifti, xifti2)

\method{-}{xifti}(xifti, xifti2)

\method{*}{xifti}(xifti, xifti2)

\method{^}{xifti}(xifti, xifti2)

\method{>}{xifti}(xifti, xifti2)

\method{>=}{xifti}(xifti, xifti2)

\method{<}{xifti}(xifti, xifti2)

\method{<=}{xifti}(xifti, xifti2)

\method{==}{xifti}(xifti, xifti2)

\method{!=}{xifti}(xifti, xifti2)

\method{^}{xifti}(xifti, xifti2)

\method{\%\%}{xifti}(xifti, xifti2)

\method{\%/\%}{xifti}(xifti, xifti2)

\method{/}{xifti}(xifti, xifti2)

\method{abs}{xifti}(x)

\method{sign}{xifti}(x)

\method{sqrt}{xifti}(x)

\method{floor}{xifti}(x)

\method{ceiling}{xifti}(x)

\method{round}{xifti}(x, digits = 0)

\method{exp}{xifti}(x)

\method{log}{xifti}(x, base = exp(1))
}
\arguments{
\item{xifti}{The xifti}

\item{FUN}{The function. If \code{xifti2} is not provided, it should be
a univariate function like \code{log} or \code{sqrt}. If
\code{xifti2} is provided, it should take in two arguments, like \code{`+`}
or \code{pmax}.}

\item{xifti2}{The second xifti, if applicable. Otherwise, \code{NULL} (default)}

\item{...}{Additional arguments to \code{FUN}}

\item{x}{The \code{"xifti"}}

\item{digits}{The number of digits to round by}

\item{base}{The log base}
}
\value{
A \code{"xifti"} storing the result of applying \code{FUN} to the input(s).
The data dimensions will be the same. The metadata of \code{xifti} will be retained,
and the metadata of \code{xifti2} will be discarded (if provided).
}
\description{
Apply a univariate transformation to each value in a \code{"xifti"} or pair of
\code{"xifti"}s. If a pair, they must share the same dimensions (brainstructures)
and number of measurements.
}
\details{
If the \code{"xifti"} had the dlabel intent, and the transformation creates
any value that is not a label value (e.g. a non-integer), then it is converted
to a dscalar.
}
\seealso{
Other functions for manipulating `xifti` objects: 
\code{\link{add_surf}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{newdata_xifti}()},
\code{\link{remove_xifti}()},
\code{\link{select_xifti}()}
}
\concept{manipulating}
