% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parc_borders.R
\name{parc_borders}
\alias{parc_borders}
\title{Parcellation borders}
\usage{
parc_borders(parc, surf = NULL, hemisphere = c("left", "right"))
}
\arguments{
\item{parc}{Integer vector the same length as the number of vertices. Each
entry indicates the parcel that vertex belongs to.}

\item{surf}{The surface which the vertices belong to, or just the \code{"faces"}
component (\eqn{F x 3} matrix where each row indicates the vertices which
comprise a face). If not provided, the (resampled) default \code{hemisphere}
surface included with \code{ciftiTools} will be used.}

\item{hemisphere}{Only used to choose which default surface to use if
\code{is.null(surf)}. Should be \code{"left"} (default) or \code{"right"}.}
}
\value{
Logical vector the same length as \code{parc} indicating if the
vertex lies on a border.
}
\description{
Identify vertices which lie on the border of different parcels.
}
