% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_lmer.R
\name{add_quantile.lmerMod}
\alias{add_quantile.lmerMod}
\title{Quantiles for the Response of a Linear Mixed Model}
\usage{
\method{add_quantile}{lmerMod}(tb, fit, p, name = NULL,
  yhatName = "pred", includeRanef = TRUE, type = "boot",
  nSims = 10000, log_response = FALSE, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{lm}. Predictions are made with
this object.}

\item{p}{A real number between 0 and 1.  Determines the probability
level of the quantiles.}

\item{name}{\code{NULL} or a string. If \code{NULL}, quantiles
automatically will be named by \code{add_quantile}, otherwise,
they will be named \code{name}.}

\item{yhatName}{A string. Determines the name of the column of
predictions.}

\item{includeRanef}{The random effects be included or not? If
\code{TRUE}, quantiles will be calculated at the
"group level". Otherwise, quantiles will be calculated at the
"population level", where random effects are set to \eqn{0}.}

\item{type}{A string. Options are \code{"parametric"} or
\code{"boot"}.}

\item{nSims}{A positive integer. Set the number of bootstrap
simulations to perform. Only applied when \code{type = "boot"}.}

\item{log_response}{A logical. Set to \code{TRUE} if the model is a
log-linear mixed model: \eqn{\log(Y) = X\beta + Z\gamma +
\epsilon}.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and level-p
    quantiles attached.
}
\description{
This function is one of the methods for \code{add_quantile} and
is called automatically when \code{add_quantile} is applied to an
object of class \code{lmerMod}.
}
\details{
\code{add_qauntile.lmerMod} may use one of two different methods
for determining quantiles: a parametric method or a parametric
bootstrap method (via \code{lme4::simulate}). The parametric method
is the default. Only use the parametric method (\code{type =
"parametric"}) if \code{fit} is a random intercept model,
e.g. \code{fit = lmer(y ~ x + (1|group))}. If your model of
interest is random slope and random intercept, use the parametric
bootstrap method (\code{type = "boot"}).
}
\examples{
dat <- lme4::sleepstudy

# Fit a random intercept model
fit <- lme4::lmer(Reaction ~ Days + (1|Subject), data = lme4::sleepstudy)

# Using the parametric method: given the model fit, what value
# of reaction time do we expect half of new reaction times to fall
# under?
add_quantile(dat, fit, p = 0.5)

# Using the parametric method:
# as above, but we ignore the random effects.
add_quantile(dat, fit, p = 0.5, includeRanef = FALSE)

}
\seealso{
\code{\link{add_ci.lmerMod}} for confidence intervals
    for \code{lmerMod} objects, \code{\link{add_pi.lmerMod}} for
    prediction intervals of \code{lmerMod} objects, and
    \code{\link{add_probs.lmerMod}} for response probabilities of
    \code{lmerMod} objects.
}
