% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_peaks.R
\name{fit_peaks}
\alias{fit_peaks}
\title{Fit chromatographic peaks to an exponential-gaussian hybrid or gaussian
profile}
\usage{
fit_peaks(
  y,
  pos = NULL,
  sd.max = 50,
  fit = c("egh", "gaussian", "raw"),
  max.iter = 1000,
  ...
)
}
\arguments{
\item{y}{response (numerical vector)}

\item{pos}{Locations of peaks in vector y. If NULL, \code{find_peaks} will
run automatically to find peak positions.}

\item{sd.max}{Maximum width (standard deviation) for peaks. Defaults to 50.}

\item{fit}{Function for peak fitting. (Currently exponential-gaussian hybrid
\code{egh}, \code{gaussian} and \code{raw} settings are supported). If \code{
raw} is selected, trapezoidal integration will be performed on raw data
without fitting a peak shape. Defaults to \code{egh}.)}

\item{max.iter}{Maximum number of iterations to use in nonlinear least
squares peak-fitting. (Defaults to 1000).}

\item{...}{Additional arguments to \code{find_peaks}.}
}
\value{
Function \code{fit_peaks} returns a matrix, whose columns contain
the following information: \item{rt}{location of the maximum of the peak
(x)} \item{start}{start of peak (only included in table if `bounds==TRUE`)}
\item{end}{end of peak (only included in table if `bounds==TRUE`)}
\item{sd}{width of the peak (x)} \item{tau}{tau parameter (only included in
table if `fit=="egh"`)} \item{FWHM}{full width at half maximum (x)}
\item{height}{height of the peak (y)} \item{area}{peak area}
\item{r.squared}{r-squared value for linear fit of model to data.}
Again, the first five elements (rt, start, end, sd and FWHM) are expressed
as indices, so not in terms of the real retention times. The transformation
to "real" time is done in function \code{get_peaks}.
}
\description{
Fit peak parameters using exponential-gaussian hybrid or gaussian function.
}
\details{
Peak parameters are calculated using \code{fit_peaks}, which fits the data
to a gaussian or exponential-gaussian hybrid curve using non-linear least
squares estimation as implemented in \code{\link[minpack.lm:nlsLM]{nlsLM}}.
Area under the fitted curve is estimated using trapezoidal estimation.
}
\note{
The \code{\link{fit_peaks}} function is adapted from Dr. Robert
Morrison's
\href{https://github.com/robertdouglasmorrison/DuffyTools}{DuffyTools package}
as well as code published in Ron Wehrens'
\href{https://github.com/rwehrens/alsace}{alsace} package.
}
\examples{
data(Sa_pr)
fit_peaks(Sa_pr[[1]][,"220"])
}
\references{
Lan, K. & Jorgenson, J. W. 2001. A hybrid of exponential and gaussian
functions as a simple model of asymmetric chromatographic peaks. \emph{Journal of
Chromatography A} \bold{915}:1-13. \doi{10.1016/S0021-9673(01)00594-5}.

Naish, P. J. & Hartwell, S. 1988. Exponentially Modified Gaussian functions - A
good model for chromatographic peaks in isocratic HPLC? \emph{Chromatographia},
/bold{26}: 285-296. \doi{10.1007/BF02268168}.
}
\seealso{
\code{\link{find_peaks}}, \code{\link{get_peaks}}
}
\author{
Ethan Bass
}
