% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_peaks.R
\name{get_peaks}
\alias{get_peaks}
\title{Get peak list.}
\usage{
get_peaks(
  chrom_list,
  lambdas,
  fit = c("egh", "gaussian", "raw"),
  sd.max = 50,
  max.iter = 100,
  ...
)
}
\arguments{
\item{chrom_list}{A list of profile matrices, each of the same dimensions
(timepoints x wavelengths).}

\item{lambdas}{Character vector of wavelengths to find peaks at.}

\item{fit}{What type of fit to use. Current options are exponential-gaussian
hybrid (\code{egh}), gaussian or raw. The \code{raw} setting performs
trapezoidal integration directly on the raw data without fitting a peak shape.}

\item{sd.max}{Maximum width (standard deviation) for peaks. Defaults to 50.}

\item{max.iter}{Maximum number of iterations for non-linear least squares
in \code{\link{fit_peaks}}.}

\item{\dots}{Additional arguments to \code{\link{find_peaks}}.}
}
\value{
The result is an S3 object of class \code{peak_list}, containing a nested
list of data.frames containing information about the peaks fitted for each
chromatogram at each specified wavelength. The data.frame includes information
about the retention time (\code{rt}), \code{start} and \code{end} of each peak,
as well as the standard deviation (\code{sd}), \code{tau} (if \code{egh} is 
selected), full width at half maximum (\code{FWHM}), \code{height}, \code{area},
and \code{r.squared} (coefficient of determination). (*Note:* This last
parameter is determined from a linear model of the fitted peak values to the
raw data. This approach is not really statistically valid but it can be useful
as a rough metric for "goodness-of-fit").
}
\description{
Finds and fits peaks and extracts peak parameters from a list of chromatograms
at the specified wavelengths.
}
\details{
Peaks are located by finding zero-crossings in the smoothed first derivative
of the specified chromatographic traces (function \code{\link{find_peaks}}).
At the given positions, an exponential-gaussian hybrid (or regular gaussian)
function is fit to the signal using \code{\link{fit_peaks}}). The area is then
calculated using a trapezoidal approximation.
}
\note{
The function is adapted from the
\href{https://github.com/rwehrens/alsace/blob/master/R/getAllPeaks.R}{getAllPeaks}
function authored by Ron Wehrens (though the underlying algorithms for peak
identification and peak-fitting are not the same).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa_pr)
pks <- get_peaks(Sa_pr, lambdas = c('210'), sd.max=50, fit="egh")
\dontshow{\}) # examplesIf}
}
\references{
Wehrens, R., Carvalho, E., Fraser, P.D. 2015. Metabolite profiling in
LC–DAD using multivariate curve resolution: the alsace package for R. \emph{
Metabolomics} \bold{11}:143-154. \doi{10.1007/s11306-014-0683-5}
}
\author{
Ethan Bass
}
