% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_pad_balanced}
\alias{par_pad_balanced}
\title{Extension of par_make_balanced for padded grids}
\usage{
par_pad_balanced(points_in = NULL, ngroups, padding)
}
\arguments{
\item{points_in}{\code{sf} or \code{SpatVector} object. Point geometries.
Default is NULL.}

\item{ngroups}{integer(1). The number of groups.}

\item{padding}{numeric(1). A extrusion factor to make buffer to
clip actual datasets. Depending on the length unit of the CRS of input.}
}
\value{
A list of two,
\itemize{
\item \code{original}: exhaustive and non-overlapping
grid polygons in the class of input
\item \code{padded}: a square buffer of each polygon in \code{original}.
Used for computation.
}
}
\description{
This function utilizes \code{\link[anticlust:balanced_clustering]{anticlust::balanced_clustering()}}
to split the input into equal size subgroups then transform the data
to be compatible with the output of \code{\link{par_pad_grid}}, for which
a set of padded grids of the extent of input point subsets
(as recorded in the field named \code{"CGRIDID"})
is generated out of input points.
}
\examples{
lastpar <- par(mfrow = c(1, 1))
library(terra)
library(sf)
options(sf_use_s2 = FALSE)

ncpath <- system.file("gpkg/nc.gpkg", package = "sf")
nc <- terra::vect(ncpath)
nc_rp <- terra::spatSample(nc, 1000)

nc_gr <- par_pad_balanced(nc_rp, 10L, 1000)
nc_gr
par(lastpar)
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_grid}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_grid}()},
\code{\link{par_split_list}()}
}
\author{
Insang Song
}
\concept{Parallelization}
