% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodEuclidean.R
\name{addNeighborhoodEuclidean}
\alias{addNeighborhoodEuclidean}
\title{Add expected Euclidean pump neighborhoods.}
\usage{
addNeighborhoodEuclidean(pump.subset = NULL, pump.select = NULL,
  vestry = FALSE, case.location = "nominal", type = "star",
  alpha.level = 0.5, multi.core = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} selects all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{case.location}{Character. "address" or "nominal". "address" is the x-y coordinates of \code{sim.ortho.proj}. "nominal" is the x-y coordinates of \code{regular.cases}.}

\item{type}{Character. Type of plot: "star", "area.points" or "area.polygons".}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\value{
R graphic elements.
}
\description{
Add expected Euclidean pump neighborhoods.
}
\note{
This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths to PDF takes about 3.6 seconds while doing so for expected paths takes about 109 seconds. Using the parallel implementation on 4 physical (8 logical) cores, these times fall to about 1.4 and 28 seconds. Note that parallelization is currently only available on Linux and Mac, and that although some precautions are taken in R.app on macOS, the developers of the 'parallel' package, which \code{neighborhoodWalking()} uses, strongly discourage against using parallelization within a GUI or embedded environment. See \code{vignette("parallel")} for details. Also, the function computes approximate of polygons, using the 'TSP' package, that may produce non-simple and/or overlapping polygons.
}
\examples{
\donttest{

streetNameLocator("marshall street", zoom = 0.5, highlight = FALSE,
  add.subtitle = FALSE)
addNeighborhoodEuclidean()

streetNameLocator("marshall street", zoom = 0.5, highlight = FALSE,
  add.subtitle = FALSE)
addNeighborhoodEuclidean(type = "area.points")
}
}
