\name{dcm.design.gencand}
\alias{dcm.design.gencand}
\title{Full factorial design}
\description{Generate a full factorial design set given
  a vector of factor lengths.
}

\usage{
dcm.design.gencand(levs)
}

\arguments{
  \item{levs}{A vector of factor lengths.}
}

\details{
  This function can be used in concert with \code{dcm.design.cand} when the candidate set must be manipulated 
  or restricted before generating a fractional factorial design. Generate the full factorial design using this
  function, manipulate it with appropriate \code{R} code. Or export the candidate generated by this function to 
  Excel or another application, and save the result as a tab-delimited text file that can be imported as part
  of the call to \code{dcm.design.cand}.
  
  Use \code{dcm.design} by itself to generate fractional factorial designs from full factorial candidate sets that
  do not require further manipulation. The required candidate set(s) are generated internally by that function
  given a vector of factor lengths as input.
} 

\value{A data frame of factors in a full factorial design.}
\seealso{\code{gen.factorial}}

\examples{
levs <- c(3,4,3,2) 
cand <- dcm.design.gencand(levs)
}