% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-matrix.R
\name{chk_matrix}
\alias{chk_matrix}
\alias{vld_matrix}
\title{Check Matrix}
\usage{
chk_matrix(x, x_name = NULL)

vld_matrix(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a matrix using

\code{is.matrix(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_matrix}: Validate Matrix
}}

\examples{

# chk_matrix
chk_matrix(matrix(1))
try(chk_matrix(array(1)))

# vld_matrix
vld_matrix(1)
vld_matrix(matrix(1))
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_environment}()},
\code{\link{chk_function}()},
\code{\link{chk_list}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
