\name{make_california_UCIPM_station_list}

\alias{make_california_UCIPM_station_list}

\title{Makes a list of the UC IPM weather stations}

\description{Makes a list of the weather stations contained in the UC IPM database, with geographic coordinates. This requires parsing through quite a few websites, because the coordinates don't seem to be stored in one central (and easily accessible) place. Hence this is much slower than one might expect. A shortcut is the california_stations dataset supplied with chillR, which contains the result of running this function in February 2016. The default in the other relevant functions will be the use of this pre-stored list, but if the current station coverage is needed, this function can help. Having said this, station coverage probably won't change very rapidly, so in most cases, the california_stations dataset should be enough.}

\usage{
make_california_UCIPM_station_list()}

\value{   a data.frame containing stations from the California UC IPM database (), with the following columns: "Name", "Code", "Interval", "Lat", "Long", "Elev".
}

\references{
The chillR package:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat requirements of cherry trees - a statistical approach. International Journal of Biometeorology 57,679-689.
}

\author{Eike Luedeling}

\examples{
#cali_stats<-make_california_UCIPM_station_list()}
\keyword{ utilities }
