% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.glm.R
\name{fit.glm}
\alias{fit.glm}
\title{fit.glm}
\usage{
fit.glm(
  formula,
  data,
  distribution = c("negative-binomial", "poisson", "truncated-poisson",
    "truncated-negative-binomial"),
  start = NULL,
  init.theta = NULL,
  maxit = 100,
  epsilon = 1e-08,
  trace = FALSE
)
}
\arguments{
\item{formula}{Formula specifying model of interest}

\item{data}{Data frame containing variables specified in formula}

\item{distribution}{Name of distribution of the counts. Options are 'negative-binomial', 
'poisson', 'truncated-poisson', and 'truncated-negative-binomial'}

\item{start}{Starting values for model coefficients}

\item{init.theta}{Initial value of theta if fitting the negative binomial distribution}

\item{maxit}{Maximum number of IWLS iterations for fitting the model (passed to \code{glm.control})}

\item{epsilon}{Positive convergence tolerance for Poisson and negative binomial models. Passed to \code{glm.control}}

\item{trace}{Logical indicating if output should be produced for each of model fitting procedure. Passed to \code{glm.control} or \code{gamlss.control}}
}
\value{
List with elements
 \item{model}{model object}
	\item{expected.values}{vector of expected values for each element in original data}
	\item{p.values}{vector of p-values for test of significantly higher response than expected}
}
\description{
Fit GLM according to a specified distribution. This needs to be done separately from \code{glm}
	in order to include negative binomial and truncated distributions as options.
}
