% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chi}
\alias{chi}
\alias{dchi}
\alias{pchi}
\alias{qchi}
\alias{rchi}
\title{The Chi Distribution}
\usage{
dchi(x, df, ncp = 0, log = FALSE)

pchi(q, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qchi(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rchi(n, df, ncp = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{df}{degrees of freedom (non-negative, but can be
non-integer).}

\item{ncp}{non-centrality parameter (non-negative).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as 
log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x] otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is 
taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random 
generation for the chi distribution.
}
\details{
The functions (d/p/q/r)chi simply wrap those of the standard 
(d/p/q/r)chisq R implementation, so look at, say, 
\code{\link{dchisq}} for details.
}
\examples{

s <- seq(0, 5, .01)
plot(s, dchi(s, 7), type = 'l')

f <- function(x) dchi(x, 7)
q <- 2
integrate(f, 0, q)
(p <- pchi(q, 7))
qchi(p, 7) # = q
mean(rchi(1e5, 7) <= q)


samples <- rchi(1e5, 7)
plot(density(samples))
curve(f, add = TRUE, col = "red")


}
\seealso{
\code{\link{dchisq}}; these functions just wrap the 
  (d/p/q/r)chisq functions.
}

