% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homogenous.R
\name{check_homogenous}
\alias{check_homogenous}
\title{Check Homogenous}
\usage{
check_homogenous(x, strict = FALSE, recursive = FALSE,
  x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{strict}{A flag indicating whether all the objects must have identical classes or just share one or more classes.}

\item{recursive}{A flag indicating whether the check should be applied recursively.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether the elements of x are all of the same class.
It works on vectors, matrices and arrays which, by definition will always
be homogenous and lists and data frames which may or may not be homogenous.
}
\examples{
check_homogenous(1:2)
check_homogenous(list(1,2))
check_homogenous(list(1,TRUE), error = FALSE)
}
\seealso{
\code{\link{check_vector}}, \code{\link{check_list}} and \code{\link{check_data}}
}
