% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkCount}
\alias{assertCount}
\alias{checkCount}
\alias{testCount}
\title{Check if an argument is a count}
\usage{
checkCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps))

assertCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps), .var.name)

testCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{positive}{[\code{logical(1)}]\cr
Must \code{x} be positive (>= 1)?
Default is \code{FALSE}, allowing 0.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertCount} throws an error message,
 \code{testCount} returns \code{FALSE} and \code{checkCount} returns
 a string with the error message.
}
\description{
A count is a non-negative integerish value.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testCount(1)
 testCount(-1)
}
\seealso{
Other scalars: \code{\link{assertFlag}},
  \code{\link{checkFlag}}, \code{\link{testFlag}};
  \code{\link{assertInt}}, \code{\link{checkInt}},
  \code{\link{testInt}}; \code{\link{assertNumber}},
  \code{\link{checkNumber}}, \code{\link{testNumber}};
  \code{\link{assertScalarNA}},
  \code{\link{checkScalarNA}}, \code{\link{testScalarNA}};
  \code{\link{assertScalar}}, \code{\link{checkScalar}},
  \code{\link{testScalar}}; \code{\link{assertString}},
  \code{\link{checkString}}, \code{\link{testString}}
}

