% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_whole_number.R
\name{is_whole_number}
\alias{is_whole_number}
\title{Very fast check that numeric vector consists only of whole numbers}
\usage{
is_whole_number(x, tol = sqrt(.Machine$double.eps), na.rm = TRUE)
}
\arguments{
\item{x}{\verb{[numeric(n)]} - A numeric vector.}

\item{tol}{\verb{[numeric(1)]} - Tolerance.}

\item{na.rm}{\verb{[logical(1)]} - Should \code{NA} values be ignored?
Default is \code{TRUE}.}
}
\value{
\code{TRUE}, \code{FALSE}, or \code{NA} (see Details)
}
\description{
Very fast check that numeric vector consists only of whole numbers
}
\details{
\code{is_whole_number()} will return \code{NA} when these 3 conditions are met:
\itemize{
\item \code{na.rm} is \code{FALSE}
\item \code{x} contains at least 1 \code{NA} value
\item \code{x} contains only a mix of whole numbers and/or \code{NA} values. If any values
are not whole numbers then we can return \code{FALSE} even with the presence of
\code{NA} values.
}

If \code{x} is not numeric then \code{is_whole_number()} always returns \code{FALSE}.
}
