% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{lag_}
\alias{lag_}
\title{Lagged operations.}
\usage{
lag_(x, n = 1, fill = NULL, set = FALSE, recursive = TRUE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{n}{Number of lags. Negative values are accepted.}

\item{fill}{Value used to fill first n values. Default is \code{NA}.}

\item{set}{Should x be updated by reference? If \code{TRUE} no copy is made and
x is updated in place. The default is \code{FALSE}.}

\item{recursive}{Should list elements be lagged as well?
If \code{TRUE}, this is useful for data frames and will return row lags.
If \code{FALSE} this will return a plain lagged list.}
}
\value{
A lagged object the same size as x.
}
\description{
Fast lags and leads
}
\examples{
library(cheapr)
library(bench)

# A use-case for data.table

df <- data.frame(x = 1:10^5)

# Lag these behind by 3 rows
sset(lag_(df, 3, set = TRUE), 1:10)

df$x[1:10] # x variable was updated by reference!

# The above can be used naturally in data.table to lag data
# without any copies

# To perform regular R row lags, just make sure set is `FALSE`

sset(lag_(as.data.frame(EuStockMarkets), 5), 1:10)
}
