% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prox_gradient_mapping}
\alias{prox_gradient_mapping}
\title{Proximal-gradient mapping method.}
\usage{
prox_gradient_mapping(data, theta_start, update_w, update_change, regularizer,
  max_iter, tol)
}
\arguments{
\item{data}{N x P matrix corresponding to the raw data.}

\item{theta_start}{Initial value for precision estimate.}

\item{update_w}{Step size for prox-gradient mapping.}

\item{update_change}{Proportion of \code{update_w} to keep when
the algorithm fails to successfully estimate precision.}

\item{regularizer}{Regularizing constant, lambda.}

\item{max_iter}{Number of mapping iterations.}

\item{tol}{Tolerance at which the algorithm stops running.}
}
\value{
Theta (precision matrix) estimate.
}
\description{
Performs the proximal-gradient mapping operation to
             estimate a regularized version of the inverse cov.
             matrix.  Follows the procedure described in,
             http://dept.stat.lsa.umich.edu/~yvesa/sto_prox.pdf
}
\author{
\packageMaintainer{changepointsHD}
}
