% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoints.R
\docType{methods}
\name{log_likelihood_method}
\alias{log_likelihood_method}
\alias{log_likelihood_method,changepointsMod-method}
\title{Wrapper method for log-likelihood estimation.}
\usage{
log_likelihood_method(object, part, tau)

\S4method{log_likelihood_method}{changepointsMod}(object, part, tau)
}
\arguments{
\item{object}{Corresponding \code{changepointsMod} class.}

\item{part}{Index for current partition, should be 1 or 2.}

\item{tau}{Current change-point.  Should be between buff and N - buff.}
}
\value{
The log-likelihood estimate for the current state.  There are currently three
        possible versions depending on the form of the \code{part_values} and
        \code{whole_values} provided.  1) If only \code{part_values} are provided,
        then we assume the log-likelihood takes only the \code{part_values.}
        2) If only \code{whole_values} are provide, we assume the log-likelihood
        takes only the \code{whole_values}. 3) If both \code{part_values}
        and \code{whole_values} are provided, we assume that the log-likelihood
        takes both.
}
\description{
Generates the log-likelihood for the specified partition given the
             current tau value.  Additionally, this wrapper handles the different
             data structures possible for part_values and whole_values.
}
\author{
\packageMaintainer{changepointsHD}
}
