% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgrcusum.R
\name{cgrcusum}
\alias{cgrcusum}
\title{Continuous time Generalized Rapid response CUSUM (CGR-CUSUM)}
\usage{
cgrcusum(
  data,
  coxphmod,
  cbaseh,
  ctimes,
  h,
  stoptime,
  C,
  pb = FALSE,
  cmethod = "memory2"
)
}
\arguments{
\item{data}{\code{data.frame} containing the following named columns:
\itemize{
\item \code{entrytime} numeric - time of entry into study,
\item \code{survtime} numeric - time from entry until event,
\item \code{censorid} integer - (optional) censoring indicator (0 = right censored, 1 = observed),
} and optionally additional covariates used for risk-adjustment.}

\item{coxphmod}{(optional) a cox proportional hazards regression model as produced by
the function \code{\link[survival:coxph]{coxph()}}. Standard practice: \cr
\code{coxph(Surv(survtime, censorid) ~ covariates, data = data)}. \cr
Alternatively, a list with:
\itemize{
\item $formula (~ covariates)
\item $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and colnames of \code{data}).
}}

\item{cbaseh}{a function which returns the non risk-adjusted cumulative
baseline hazard \eqn{H_0(t)}{H_0(t)}. If \code{cbaseh} is missing but
\code{coxphmod} has been
specified as a survival object, this baseline hazard rate will be determined
using the provided \code{coxphmod}.}

\item{ctimes}{(optional) vector of construction times at which the value of the chart should be
determined. When not specified, the chart is constructed at all failure times.}

\item{h}{(optional) value of the control limit. The chart will only be
constructed until the value of the control limit has been reached or
surpassed.}

\item{stoptime}{(optional) time after which the value of the chart should no
longer be determined. Default = max(failure time). Useful when ctimes
has not been specified.}

\item{C}{(optional) a numeric value indicating how long after entering the study
patients should no longer influence the value of the chart. This is
equivalent to right-censoring every observation at time \code{entrytime} + C.}

\item{pb}{(optional) boolean indicating whether a progress bar should be shown.
Default = FALSE}

\item{cmethod}{One of the following:
\itemize{
\item "memory2" (default) Matrix formulation of the problem (faster for high volume/long time construction - less RAM than "memory")
\item "CPU" Calculates the value of the CGR-CUSUM for every time point from scratch. Recommended for small data volume (lower initialization time).
\item "memory" (outdated) Matrix formulation of the problem (faster for high volume/long time construction - may require much RAM)
}}
}
\value{
An object of class "cgrcusum" containing:
\itemize{
\item \code{CGR}: a data.frame with named columns:
\itemize{
\item $time (time of construction),
\item $value (value of the chart at $time),
\item $exp_theta_t (value of MLE \eqn{e^{\theta_t}}{e^(\theta_t)}),
\item $S_nu (time from which patients are considered for constructing the chart)
}
\item \code{call}: Contains the \code{call} used to obtain output;
\item \code{stopind}: (only if h specified) Boolean indicating whether the chart was stopped by the provided value of h;
\item \code{h}: Specified value for the control limit;
}There are \code{\link[cgrcusum:plot.cgrcusum]{plot}} and
\code{\link[cgrcusum:runlength.cgrcusum]{runlength}} methods for "cgrcusum" objects.
}
\description{
This function performs the CGR-CUSUM procedure
described in ARTICLE UNDER REVIEW FOR PUBLICATION. For detection purposes, it is sufficient
to only determine the value of the chart at the times of failure. This can be
achieved by leaving \code{ctimes} empty.
}
\details{
The CGR-CUSUM can be used to test for a change of unknown positive fixed size \eqn{\theta}{\theta}
in the subject-specific hazard rate from \eqn{h_i(t)}{h_i(t)} to \eqn{h_i(t) e^\theta}{h_i(t) exp(\theta)}
starting from some unknown patient \eqn{\nu}{\nu}. The starting time of the first patient
which had an increase in failure rate as well as the estimated increase in the
hazard rate are also given in the output.
The CGR-CUSUM is determined as:
\deqn{\max_{1 \leq \nu \leq n} \left( \hat{\theta}_{\geq \nu}(t) N_{\geq \nu}(t) - \left( \exp\left( \hat{\theta}_{\geq \nu}(t) \right) - 1 \right) \Lambda_{\geq \nu}(t)\right)}{max{1<=\nu<=n} (\theta_{>=\nu}(t)N_{>=\nu}(t)) - (exp(\theta_{>=\nu}(t))-1) \Lambda_{>=\nu}(t))}
with  \deqn{N(\geq \nu)(t) = \sum_{i \geq \nu} N_i(t)}{N_{>=\nu}(t) = \sum_{i>=\nu} N_i(t)}
with \eqn{N_i(t)}{N_i(t)} the counting process for the failure at time t of subject i
and \deqn{\Lambda_{\geq \nu}(t) = \sum_{i \geq \nu} \Lambda_i(t)}{\Lambda_{>=\nu}(t) = \sum_{i>=\nu}\Lambda_i(t)} the
with \eqn{\Lambda_i(t)}{\Lambda_i(t)} the cumulative intensity of subject i at time t.
}
\examples{
require(survival)
tdat <- subset(surgerydat, Hosp_num == 1)
tcbaseh <- function(t) chaz_exp(t, lambda = 0.01)
varsanalysis <- c("age", "sex", "BMI")
exprfit <- as.formula(paste("Surv(survtime, censorid) ~" ,paste(varsanalysis, collapse='+')))
tcoxmod <- coxph(exprfit, data= surgerydat)
#Alternatively, cbaseh can be left empty when specifying coxphmod through coxph()
cgr <- cgrcusum(data = tdat, coxphmod = tcoxmod, cbaseh = tcbaseh, pb = TRUE)
plot(cgr)
}
\seealso{
\code{\link[cgrcusum]{plot.cgrcusum}}, \code{\link[cgrcusum]{runlength.cgrcusum}}

Other qcchart: 
\code{\link{bercusum}()},
\code{\link{bkcusum}()},
\code{\link{funnelplot}()}
}
\author{
Daniel Gomon
}
\concept{qcchart}
