% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.approx.grad}
\alias{cg.approx.grad}
\title{Approximate Gradients}
\arguments{
\item{x}{character scalar, name of the node.}

\item{y}{character scalar, name of the node.}

\item{values}{named list or environment, values that are subsituted for the nodes in the graph.}

\item{index}{numeric scalar, index of the target node that is differentiated. Defaults to the first element.}

\item{eps}{numeric scalar, step size. Defaults to 1e-4.}
}
\value{
numeric vector or array, the derivative of \code{x} with respect to \code{y}.
}
\description{
Differentiate node \code{x} with respect to node \code{y} by numerical differentiation.
}
\details{
\code{$approx.grad(x, y, values = list(), index = 1, eps = 1e-4)}
}
\note{
All nodes required to compute node \code{name} must have a value, or their value must be able to be computed at run-time. The values of nodes can be obtained by first evaluating node \code{name} in the graph using function \code{$run()}. The values obtained by this function for the nodes can then be supplied to argument \code{values}.

The graph is differentiation by the symmetric difference quotient. This method can only be used to differentiate scalars. In case the value of target node \code{name} is a vector or an array, argument \code{index} can be used to specify which element of the vector or array is differentiated. The caluclated gradient has the same shape as the value of node \code{y}.

Numerical differentiation is subject to estimation error and can be very slow. Therefore, this function should only be used for testing purposes.

There is a wrapper function \link[cgraph]{approx.grad} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add some parameters.
a <- x$parm(2, name = "a")
b <- x$parm(4, name = "b")

# Perform some operations on the parameters.
c <- sin(a) + cos(b) - tan(a)

# Differentiate the graph with respect to c.
grads <- x$gradients(c, x$run(c))

# Retrieve the gradient of c with respect to a.
grads$a

# Approximate the same gradient with numerical differentiation.
x$approx.grad(c, a)

}
\author{
Ron Triepels
}
