% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.name}
\alias{cg.name}
\title{Generate Name}
\arguments{
\item{type}{numeric scalar, type of the node. Should be either: 0 (constant), 1 (input), 2 (parameter), or 3 (operation). Defaults to 3 (operation).}
}
\value{
symbol, auto-generated name for the node.
}
\description{
Generate a default name for a node.
}
\details{
\code{$name(type = 3)}
}
\note{
The auto-generated name is not guaranteed to be unique.

There is a wrapper function \link[cgraph]{name} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Generate some names
x$name(0); x$name(1); x$name(2); x$name(3)

}
\author{
Ron Triepels
}
