\name{incr}

\alias{incr}

\title{Specify an Increasing Shape-Restriction in a CGAM Formula}

\description{
A symbolic routine to define that the systematic component \eqn{\eta} is increasing in a predictor in a formula argument to cgam. This is the unsmoothed version.}

\usage{incr(x, numknots = 0, knots = 0, space = "Q")}

\arguments{
  \item{x}{A numeric predictor which has the same length as the response vector.}
  \item{numknots}{The number of knots used to smoothly constrain a predictor. The value should be \eqn{0} for a shape-restricted predictor without smoothing. The default value is \eqn{0}.}
  \item{knots}{The knots used to smoothly constrain a predictor. The value should be \eqn{0} for a shape-restricted predictor without smoothing. The default value is \eqn{0}.}
 \item{space}{A character specifying the method to create knots. It will not be used for a shape-restricted predictor without smoothing. The default value is "Q".}
}

\value{The vector x with five attributes, i.e., name: the name of x; shape: 1("increasing"); numknots: the numknots argument in "incr"; knots: the knots argument in "incr"; space: the space argument in "incr".}

\details{
  "incr" returns the vector "x" and imposes on it five attributes: name, shape, numknots, knots and space. 

  The name attribute is used in the subroutine plotpersp; the numknots, knots and space attributes are the same as the numknots, knots and space arguments in "incr"; the shape attribute is 1("increasing"), and according to the value of the vector itself and its attributes, the cone edges of the cone generated by the constraint matrix, which constrains the relationship between the systematic component \eqn{\eta} and "x" to be increasing,  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "incr" does not make the corresponding cone edges itself. It sets things up to a subroutine called makedelta in cgam.

  See references cited in this section for more details.
}

\references{
  Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\examples{
  data(cubic)

  # extract x
  x <- cubic$x

  # extract y
  y <- cubic$y

  # regress y on x with the shape restriction: "increasing"
  ans <- cgam(y ~ incr(x))

  # make a plot
  par(mar = c(4, 4, 1, 1))
  plot(x, y, cex = .7, xlab = "x", ylab = "y")
  lines(x, ans$muhat, col = 2)
  legend("topleft", bty = "n", "increasing fit", col = 2, lty = 1)
}

\seealso{
  \code{\link{incr.conc}}, \code{\link{incr.conv}}
}

\keyword{shape routine}
