% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_play.R
\name{cfbd_plays}
\alias{cfbd_plays}
\title{\strong{Get college football play-by-play data.}}
\usage{
cfbd_plays(
  year = 2020,
  season_type = "regular",
  week = 1,
  team = NULL,
  offense = NULL,
  defense = NULL,
  conference = NULL,
  offense_conference = NULL,
  defense_conference = NULL,
  play_type = NULL
)
}
\arguments{
\item{year}{Select year, (example: 2018)}

\item{season_type}{Select Season Type (regular, postseason, both)}

\item{week}{Select week, this is optional (also numeric)}

\item{team}{Select team name (example: Texas, Texas A&M, Clemson)}

\item{offense}{Select offense name (example: Texas, Texas A&M, Clemson)}

\item{defense}{Select defense name (example: Texas, Texas A&M, Clemson)}

\item{conference}{Select conference name (example: ACC, B1G, B12, SEC,
PAC, MAC, MWC, CUSA, Ind, SBC, AAC, Western, MVIAA, SWC, PCC, Big 6, etc.)}

\item{offense_conference}{Select conference name (example: ACC, B1G, B12, SEC,
PAC, MAC, MWC, CUSA, Ind, SBC, AAC, Western, MVIAA, SWC, PCC, Big 6, etc.)}

\item{defense_conference}{Select conference name (example: ACC, B1G, B12, SEC,
PAC, MAC, MWC, CUSA, Ind, SBC, AAC, Western, MVIAA, SWC, PCC, Big 6, etc.)}

\item{play_type}{Select play type (example: see the \link{cfbd_play_type_df})}
}
\value{
\code{\link[=cfbd_plays]{cfbd_plays()}} - A data frame with 29 columns:
\describe{
\item{\code{play_id}: character.}{Referencing play id.}
\item{\code{offense}: character.}{Offense on the field.}
\item{\code{offense_conference}: character.}{Conference of the offense on the field.}
\item{\code{defense}: character.}{Defense on the field.}
\item{\code{defense_conference}: character.}{Conference of the defense on the field.}
\item{\code{home}: character.}{Home team.}
\item{\code{away}: character.}{Away team.}
\item{\code{offense_score}: integer.}{Offense's post-play score.}
\item{\code{defense_score}: integer.}{Defense's post-play score.}
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{drive_id}: character.}{Referencing drive id.}
\item{\code{drive_number}: integer.}{Drive number in the game.}
\item{\code{play_number}: integer.}{Play number in the game.}
\item{\code{period}: integer.}{Game period (quarter).}
\item{\code{offense_timeouts}: integer.}{Timeouts for the offense at the end of the play.}
\item{\code{defense_timeouts}: integer.}{Timeouts for the defense at the end of the play.}
\item{\code{yard_line}: integer.}{Yard line (~0-50) of the play.}
\item{\code{yards_to_goal}: integer.}{Yards to the goal line (~0-100).}
\item{\code{down}: integer.}{Down of the play.}
\item{\code{distance}: integer.}{Distance to the sticks, i.e. 1st down or goal-line in goal-to-go situations.}
\item{\code{scoring}: logical.}{Scoring play flag.}
\item{\code{yards_gained}: integer.}{Yards net gained by the offense on the play.}
\item{\code{play_type}: character.}{Categorical label of the type of the play.}
\item{\code{play_text}: character.}{A text description of the play.}
\item{\code{ppa}: character.}{Predicted Points Added (calculated by CFBD).}
\item{\code{clock.minutes}: integer.}{Minutes left on the clock.}
\item{\code{clock.seconds}: integer.}{Seconds left on the clock.}
}
}
\description{
\strong{Get college football play-by-play data.}
}
\examples{
\dontrun{
  try(cfbd_plays(year = 2021, week = 1))
}
}
