% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_play.R
\name{cfbd_play}
\alias{cfbd_play}
\title{\strong{CFBD Plays Endpoint Overview}}
\description{
College football plays data
\describe{
\item{\code{cfbd_plays()}:}{ CFBD's college football play-by-play.}
\item{\code{cfbd_play_stats_player()}:}{ Gets player info associated by play.}
\item{\code{cfbd_play_stats_types()}:}{ Gets CFBD play stat types.}
\item{\code{cfbd_play_types()}:}{ Gets CFBD play types.}
}
}
\details{
\subsection{\strong{Pull first 3 weeks of 2020 season using \code{cfbd_plays()}}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ year_vector <- 2020
 week_vector <- 1:3
 weekly_year_df <- expand.grid(year = year_vector, week = week_vector)
 tictoc::tic()
 year_split <- split(weekly_year_df, weekly_year_df$year)
 for (i in 1:length(year_split)) \{
   i <- 1

   progressr::with_progress(\{
      year_split[[i]] <- year_split[[i]] \%>\%
         dplyr::mutate(
            pbp = purrr::map2(
                .x = year,
                .y = week,
                cfbd_plays,
                season_type = "both"
            )
         )
     Sys.sleep(1)
   \})
 \}

 tictoc::toc()
 year_split <- lapply(year_split, function(x) \{
     x \%>\% tidyr::unnest(pbp, names_repair = "minimal")
 \})

 all_years <- dplyr::bind_rows(year_split)
 glimpse(all_years)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Gets player info associated by play}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_play_stats_player(game_id = 401110722)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Gets CFBD play stat types}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_play_stats_types()
}\if{html}{\out{</div>}}
}

\subsection{\strong{Gets CFBD play types}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_play_types()
}\if{html}{\out{</div>}}
}
}
