% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coral_plots.R
\name{local_fit}
\alias{local_fit}
\title{Local Fit / Wangkardu Explanations}
\usage{
local_fit(
  explainer,
  observation,
  selected_variable,
  grid_points = 101,
  select_points = 0.1
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'DALEX::explain' function}

\item{observation}{a new observarvation for which predictions need to be explained}

\item{selected_variable}{variable to be presented in the local fit plot}

\item{grid_points}{number of points used for response path}

\item{select_points}{fraction of points fromvalidation data to be presented in local fit plots}
}
\value{
An object of the class 'local_fit_explainer'.
It's a data frame with calculated average responses.
}
\description{
Local Fit / Wangkardu Explanations
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

cr_rf <- local_fit(explainer_rf, observation = new_apartment,
    select_points = 0.002, selected_variable = "surface")
cr_rf
}
}
