% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georeference.R
\name{mercator_tile_extent}
\alias{mercator_tile_extent}
\title{Tile extent}
\usage{
mercator_tile_extent(tile_x, tile_y, zoom, tile_size = 256)
}
\arguments{
\item{tile_x}{x coordinate of tile}

\item{tile_y}{y coordinate of tile}

\item{zoom}{zoo level}

\item{tile_size}{tile dimensions (assumed square, i.e. 256x256)}
}
\value{
A numeric vector of the spatial extent, in 'xmin', 'xmax', 'ymin', 'ymax' form.
}
\description{
Calculate tile extent for a given x, y tile at a zoom level.
}
\details{
Currently only spherical Mercator is supported.
}
\examples{
mercator_tile_extent(2, 4, zoom = 10)

global <- mercator_tile_extent(0, 0, zoom = 0)
plot(NA, xlim = global[c("xmin", "xmax")], ylim = global[c("ymin", "ymax")])
rect_plot <- function(x) rect(x["xmin"], x["ymin"], x["xmax"], x["ymax"])
rect_plot(mercator_tile_extent(1, 1, zoom = 2))
rect_plot(mercator_tile_extent(2, 1, zoom = 2))
rect_plot(mercator_tile_extent(1, 2, zoom = 2))

rect_plot(mercator_tile_extent(1, 1, zoom = 4))
rect_plot(mercator_tile_extent(2, 1, zoom = 4))
rect_plot(mercator_tile_extent(1, 2, zoom = 4))
}
