% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-mapbox.R
\name{get_api_key}
\alias{get_api_key}
\title{Get API key for Mapbox service}
\usage{
get_api_key(api = "mapbox", ...)
}
\arguments{
\item{api}{character string denoting which service ("mapbox" only)}

\item{...}{currently ignored}
}
\value{
The stored API key value, see Details.
}
\description{
Mapbox tile providers require an API key. Other providers may not need a key and so this is ignored.
}
\details{
The \href{https://CRAN.r-project.org/package=mapdeck/}{mapdeck package} has a more comprehensive tool for
setting the Mapbox API key, if this is in use ceramic will find it first and use it.

To set your Mapbox API key obtain a key from \url{https://account.mapbox.com/access-tokens/}
\preformatted{
1) Run this to set for the session 'Sys.setenv(MAPBOX_API_KEY=<yourkey>)'

OR,

2) To set permanently store 'MAPBOX_API_KEY=<yourkey>' in '~/.Renviron'.
}

There is a fairly liberal allowance for the actual name of the environment variable, any of
'MAPBOX_API_KEY', 'MAPBOX_API_TOKEN', 'MAPBOX_KEY', 'MAPBOX_TOKEN', or 'MAPBOX' will work (and they are
sought in that order).

If no key is available, \code{NULL} is returned, with a warning.
}
\examples{
get_api_key()
}
