% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{CV}
\alias{CV}
\title{The cross-validation bandwidth selection for weighted data}
\usage{
CV(X, wt, ktype = "normal")
}
\arguments{
\item{X}{The numeric data vector.}

\item{wt}{The non-negative weight vector.}

\item{ktype}{A character string giving the type kernel to be used: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". By default, the "\code{normal}" kernel is used.}
}
\value{
Returns the computed value for the bandwith parameter.
}
\description{
This function computes the data-driven bandwidth for smoothing the ROC (or distribution) function using the CV method of Beyene and El Ghouch (2020). This is an extension of the classical (unweighted) cross-validation bandwith selection method to the case of weighted data.
}
\details{
Bowman et al (1998) proposed the cross-validation bandwidth selection method for unweighted kernal smoothed distribution function. This method is implemented in the \code{R} package \code{kerdiest}.
We adapted this for the case of weighted data by incorporating the weight variable into the cross-validation function of Bowman's method. See Beyene and El Ghouch (2020) for details.
}
\examples{
\dontrun{library(cenROC)

X <- rnorm(100) # random data vector
wt <- runif(100) # weight vector

## Cross-validation bandwidth selection
CV(X = X, wt = wt)$bw

}
}
\references{
Beyene, K. M. and El Ghouch A. (2020). Smoothed time-dependent ROC curves for right-censored survival data. \emph{submitted}.

Bowman A., Hall P. and Trvan T.(1998). Bandwidth selection for the smoothing of distribution functions. \emph{Biometrika} 85:799-808.

Quintela-del-Rio, A. and Estevez-Perez, G. (2015). \code{kerdiest:} Nonparametric kernel estimation of the distribution function, bandwidth selection and estimation of related functions. \code{R} package version 1.2.
}
\author{
Kassu Mehari Beyene, Catholic University of Louvain. \code{<kasu.beyene@uclouvain.be>}

Anouar El Ghouch, Catholic University of Louvain. \code{<anouar.elghouch@uclouvain.be>}
}
