% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunemap-integration.R
\name{get.immap.metadata}
\alias{get.immap.metadata}
\title{Get  Track Metadata from ImmuneMap}
\usage{
get.immap.metadata(
  input,
  warn.exclude = TRUE,
  exclude.names = c("points", "cellTypeObject", "date")
)
}
\arguments{
\item{input}{a parsed json file obtained with \code{\link{parse.immap.json}}}

\item{warn.exclude}{logical: if \code{TRUE} (default), warn when key-value pairs in the json 
(other than those in exclude.names) are being ignored while parsing immunemap json.}

\item{exclude.names}{if the json contains keys with these names, they are ignored when reading
the metadata.}
}
\value{
a dataframe with metadata. This function currently only handles metadata with a single
	value for each track and ignores others (with a warning when \code{warn.exclude=TRUE}).
	column names in the dataframe correspond to the keys in the original json, and values to
 the values for each track.
}
\description{
Get metadata from tracks obtained from \url{https://immunemap.org} and import into celltrackR.
}
\examples{
## Read tracks from immunemap online
input <- parse.immap.json( url = "https://api.immunemap.org/video/14/tracks" )
meta.df <- get.immap.metadata( input )

## Repeat but ignore also the 'color' column:
exclude <-  c("points", "cellTypeObject","date", "color")
meta.df <- get.immap.metadata( input, exclude.names = exclude )

}
