% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.ALS.R
\name{group.ALS}
\alias{group.ALS}
\title{Alternating Least Squares with Groups for Constrained Dual Scaling}
\usage{
group.ALS(a, m, q, G, Fr.cent, eps = 0.1, maxit = 50, Mmat,
  info.level = 2, const, K, n, tol)
}
\arguments{
\item{a}{A \code{2n}-vector of row scores.}

\item{m}{Integer; the number of items.}

\item{q}{Integer; the rating scale from \code{1:q}.}

\item{G}{An indicator matrix of size \code{n} by \code{K}.}

\item{Fr.cent}{The centred F_r matrix.}

\item{eps}{The numerical tolerance level for the loss.}

\item{maxit}{Integer; the maximum number of iterations allowed.}

\item{Mmat}{Matrix of spline basis functions.}

\item{info.level}{Integer controlling the amount of information printed.}

\item{const}{The constant part of the loss function.}

\item{K}{The number of latent classes.}

\item{n}{The number of samples.}

\item{tol}{tolerance \code{tol} passed to \code{\link{lsei}} of the
\pkg{limSolve} package}
}
\description{
Alternating least-sqaures for estimating row and column scores in constrained
dual scaling, where different groups are allowed for.
}
\keyword{multivariate}

