% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.cds.R
\name{plot.cds}
\alias{plot.cds}
\title{Plot cds Objects}
\usage{
\method{plot}{cds}(x, which = 1L:3L, type = "l", lty = 1, lwd = 2,
  show.legend = TRUE, col = colorspace::rainbow_hcl(nr), bty.legend = "n",
  intercept = ncol(x$alphamat) == 4, scale = FALSE, add = FALSE,
  exp.factor = 1.2, bubble.fact = 0.12, cont.factor = 0.01, pch = 15,
  ...)
}
\arguments{
\item{x}{An object of class \code{cds}.}

\item{which}{A numeric vector: a subset of \code{1:3} specifying the plots to produce.}

\item{type}{Passed to \code{\link{matplot}}.}

\item{lty}{Passed to \code{\link{matplot}}.}

\item{lwd}{Passed to \code{\link{matplot}}.}

\item{show.legend}{Logical; should a legend be added to the plot or not.}

\item{col}{Passed to \code{\link{matplot}}.}

\item{bty.legend}{Passed to \code{\link{legend}}.}

\item{intercept}{Logical indicating whether to plot the intercept.}

\item{scale}{Logical indicating whether an intercept should be included or not.}

\item{add}{Logical; add to plot or not?}

\item{exp.factor}{Factor for expanding the x- and y-limits.}

\item{bubble.fact}{Passed to \code{\link{calc.wt.bubbles}} as argument \code{fact}.}

\item{cont.factor}{Continuity correction to apply in case one of the alpha's are
equal to zero.}

\item{pch}{Plotting character to use.}

\item{\dots}{Additional arguments passed to \code{\link{points}}.}
}
\description{
Plot method for \code{cds} objects
}
\keyword{utility}

