% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchCount.R
\name{matchCount}
\alias{matchCount}
\title{Counts distinct pixel pairs in CDL raster images}
\usage{
matchCount(x, y, m = 256)
}
\arguments{
\item{x}{A CDL raster image.}

\item{y}{A CDL raster image.}

\item{m}{A bound for the max enumeration of CDL categories.  The default is 256.}
}
\value{
A matrix with pixel counts by unique ordered CDL crop pairs in x and y.
}
\description{
\code{matchCount} counts distinct pixel pairs for CDL raster images with 
 same extents and resolution.
}
\examples{
\dontrun{
z1 <- matrix( rep(c(1,4),8), nrow=4) 
z2 <- matrix( rep(c(1:4),4), nrow=4) 

r1 <- raster(z1)
r2 <- raster(z2)

a <- matchCount(r1,r2)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}
}
