% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdcov.R
\name{cdcov}
\alias{cdcov}
\alias{cdcor}
\title{Conditional Distance Covariance/Correlation Statistics}
\usage{
cdcov(x, y, z, width, index = 1, distance = FALSE)

cdcor(x, y, z, width, index = 1, distance = FALSE)
}
\arguments{
\item{x}{a numeric vector, matrix, or \code{dist} object}

\item{y}{a numeric vector, matrix, or \code{dist} object}

\item{z}{\code{z} is a numeric vector or matrix. It is the variable being conditioned.}

\item{width}{a user-specified positive value (univariate conditional variable) or vector (multivariate conditional variable) for 
gaussian kernel bandwidth. Its default value is relies on \code{stats::bw.nrd0}.}

\item{index}{exponent on Euclidean distance, in \eqn{(0,2]}}

\item{distance}{if \code{distance = TRUE}, \code{x} and \code{y} will be considered as distance matrices. Default: \code{distance = FALSE}.}
}
\value{
\item{\code{cdcov }}{ conditional distance covariance test statistic.}

\item{\code{cdcor }}{ conditional distance correlation statistic.}
\item{\code{cdc }}{ conditional distance covariance/correlation vector.}
}
\description{
Computes conditional distance covariance and conditional distance correlation statistics, 
which are multivariate measures of conditional dependence.
}
\details{
\code{cdcov} and \code{cdcor} compute conditional distance covariance and conditional distance correlation statistics.
The sample sizes (number of rows or length of the vector) of the two variables must agree, 
and samples must not contain missing values. 
If we set \code{distance = TRUE}, arguments \code{x}, \code{y} can be a \code{dist} object recording distance between samples; 
otherwise, these arguments are treated as multivariate data.
}
\examples{
library(cdcsis)

############# Conditional Distance Covariance #############
set.seed(1)
x <- rnorm(25)
y <- rnorm(25)
z <- rnorm(25)
cdcov(x, y, z)
############# Conditional Distance Correlation #############
num <- 25
set.seed(1)
x <- rnorm(num)
y <- rnorm(num)
z <- rnorm(num)
cdcor(x, y, z)
}
\references{
Wang, X., Pan, W., Hu, W., Tian, Y. and Zhang, H., 2015. Conditional distance correlation. Journal of the American Statistical Association, 110(512), pp.1726-1734.
}
\seealso{
\code{\link{cdcor}}
}
\author{
Canhong Wen, Wenliang Pan, and Xueqin Wang
}
