% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alcohol.R
\name{low_drink_score_fun1}
\alias{low_drink_score_fun1}
\title{Low drinking score (select cycles)}
\usage{
low_drink_score_fun1(DHH_SEX, ALWDWKY, ALC_005, ALC_1)
}
\arguments{
\item{DHH_SEX}{Sex of respondent (1 - male, 2 - female)}

\item{ALWDWKY}{Number of drinks consumed in the past week}

\item{ALC_005}{In lifetime, ever had a drink? (1 - yes, 2 - no)}

\item{ALC_1}{Past year, have you drank alcohol? (1 - yes, 2 - no)}
}
\value{
Low risk drinking score (low_drink_score1) with four categories:
\itemize{
  \item 1 - Low risk - never drank (0 points)
  \item 2 - Low risk - former drinker (0 points)
  \item 3 - Marginal risk (1-2 points)
  \item 4 - Medium risk (3-4 points)
  \item 5 - High risk (5-9 points)
 }
}
\description{
This function creates a derived variable based on their drinking 
habits and flags for health and social problems from their pattern of 
alcohol use according to Canada's Low-Risk Alcohol Drinking Guideline.
}
\details{
The low risk drinking score is based on the scoring system in 
Canada's Low-Risk Alcohol Drinking Guideline. The score is divided into two 
steps. Step 1 allocates points based on sex and the number of drinks 
that you usually have each week. In step 2, one point will be awarded for 
each item that is true related to drinking habits. The total score is 
obtained from adding the points in step 1 and step 2.

This score has two 0 point categories: low risk (never drank) and low risk 
(former drinker). The two drinking groups are derived from 'ever had a drink 
in lifetime'. 'Ever had a drink in lifetime' is only available in CCHS 
2001-2008 and 2015-2018.
}
\note{
Step 2 is not included in this function because the questions in 
step 2 are not asked in any of the CCHS cycles. The score is only based on 
step 1.

See \url{https://osf.io/eprg7/} for more details on the guideline and score.
}
\examples{
 
# Using low_drink_score_fun1() to create low_drink_score values across 
# CCHS cycles low_drink_score_fun1() is specified in variable_details.csv 
# along with the CCHS variables and cycles included.

# To transform low_drink_score1, use rec_with_table() for each CCHS cycle
# and specify low_drink_score1, along with the various alcohol and sex
# variables. 
# Using merge_rec_data(), you can combine low_drink_score1 across cycles.

library(cchsflow)
low_drink2001 <- rec_with_table(
  cchs2001_p, c(
    "DHH_SEX", "ALWDWKY", "ALC_005", "ALC_1", "low_risk_score"
  )
)

head(low_drink2001)

low_drink2009_2010 <- rec_with_table(
  cchs2009_2010_p, c(
    "DHH_SEX", "ALWDWKY", "ALC_005", "ALC_1", "low_risk_score"
  )
)

tail(low_drink2009_2010)

combined_low_drink1 <- bind_rows(low_drink2001, 
low_drink2009_2010)

head(combined_low_drink1)

tail(combined_low_drink1)

}
