% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diet.R
\name{diet_score_fun}
\alias{diet_score_fun}
\title{Diet score}
\usage{
diet_score_fun(FVCDFRU, FVCDSAL, FVCDPOT, FVCDCAR, FVCDVEG, FVCDJUI, DHH_SEX)
}
\arguments{
\item{FVCDFRU}{daily consumption of fruit}

\item{FVCDSAL}{daily consumption of green salad}

\item{FVCDPOT}{daily consumption of potatoes}

\item{FVCDCAR}{daily consumption of carrots}

\item{FVCDVEG}{daily consumption of other vegetables}

\item{FVCDJUI}{daily consumption of fruit juice}

\item{DHH_SEX}{sex; 1 = male, 2 = female}
}
\description{
This function creates a derived diet variable (diet_score)
 based on consumption of fruit, salad, potatoes, carrots, other vegetables
 and juice. 2 baseline points plus summation of total points for diet
 attributes. Negative overall scores are recoded to 0, resulting in a range
 from 0 to 10.

\itemize{
  \item 1 point per daily fruit and vegetable consumption, excluding fruit 
  juice (maximum 8 points).
  \item -2 points for high potato intake (>=7 (males),
   >=5 (females) times/week)
  \item -2 points for no carrot intake
  \item -2 points per daily frequency of fruit juice consumption greater than 
  once/day (maximum -10 points)
 }
}
\details{
While diet score can be calculated for all survey respondents, in
 the 2005 CCHS survey cycle, fruit and vegetable consumption was an optional
 section in which certain provinces had opted in to be asked to respondents.
 In this survey cycle, fruit and vegetable consumption was asked to
 respondents in British Columbia, Ontario, Alberta, and Prince Edward Island.
 As such, diet score has a large number of missing respondents for this 
 cycle.
}
\examples{
# Using the 'diet_score_fun' function to create the derived diet variable  
# across CCHS cycles.
# diet_score_fun() is specified in the variable_details.csv

# To create a harmonized diet_score variable across CCHS cycles, use 
# rec_with_table() for each CCHS cycle and specify diet_score_fun and the
# required base variables.
# Using merge_rec_data(), you can combine smoke_simple across cycles

library(cchsflow)

diet_score2009_2010 <- rec_with_table(
  cchs2009_2010_p, c(
    "FVCDFRU", "FVCDSAL", "FVCDPOT", "FVCDCAR", "FVCDVEG", "FVCDJUI", 
    "DHH_SEX", "diet_score_fun"
  )
)

head(diet_score2009_2010)

diet_score2011_2012 <- rec_with_table(
  cchs2011_2012_p,c(
    "FVCDFRU", "FVCDSAL", "FVCDPOT", "FVCDCAR", "FVCDVEG", "FVCDJUI", 
    "DHH_SEX", "diet_score_fun"
  )
)

tail(diet_score2011_2012)

combined_diet_score <- suppressWarnings(merge_rec_data(diet_score2009_2010,
 diet_score2011_2012))

head(combined_diet_score)
tail(combined_diet_score)
}
