#' variables.csv
#'
#' This dataset lists all the variables that are present in cchsflow.
#'
#' See the below link for more details about how the worksheet is structured
#' \url{https://big-life-lab.github.io/cchsflow/articles/variables_sheet.html}
#'
#'
#' @name variables
#' @aliases variables
#' @docType data
#' @return \item{variables}{a data frame}
#'
#' @keywords datasets
#' @examples
#' data(variables)
#' str(variables)
NULL

#' variable_details.csv
#'
#' This dataset provides details on how variables are recoded in cchsflow.
#'
#' See the below link for more details about how the worksheet is structured
#' \url{https://big-life-lab.github.io/cchsflow/articles/variable_details.html}
#'
#' @name variable_details
#' @aliases variable_details
#' @docType data
#' @return \item{variable_details}{a data frame}
#'
#' @keywords datasets
#' @examples
#' data(variable_details)
#' str(variable_details)
NULL

#' 2001 CCHS data
#'
#' This is a subset of 200 observations from the 2001 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: cchs-82M0013-E-2001-c1-1-general-file
#'
#' DDI: \url{https://osf.io/jtd9h/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2001
#' @aliases cchs2001
#' @docType data
#' @return \item{cchs2001}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=3359}
#'
#' @keywords datasets
#' @examples
#' data(cchs2001)
#' str(cchs2001)
NULL

#' 2003 CCHS data
#'
#' This is a subset of 200 observations from the 2003 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#'
#' Long name: cchs-82M0013-E-2003-c2-1-General File
#'
#' DDI: \url{https://osf.io/nzq37/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2003
#' @aliases cchs2003
#' @docType data
#' @return \item{cchs2003}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=4995}
#'
#' @keywords datasets
#' @examples
#' data(cchs2003)
#' str(cchs2003)
NULL

#' 2005 CCHS data
#'
#' This is a subset of 200 observations from the 2005 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#'
#' Long name: cchs-82M0013-E-2005-c3-1-main-file
#'
#' DDI: \url{https://osf.io/35mhq/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2005
#' @aliases cchs2005
#' @docType data
#' @return \item{cchs2005}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=22642}
#'
#' @keywords datasets
#' @examples
#' data(cchs2005)
#' str(cchs2005)
NULL

#' 2007-2008 CCHS data
#'
#' This is a subset of 200 observations from the 2007-2008 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: cchs-E-2007-2008-AnnualComponent
#'
#' DDI: \url{https://osf.io/emzsp/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2007_2008
#' @aliases cchs2007_2008
#' @docType data
#' @return \item{cchs2007_2008}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=29539}
#'
#' @keywords datasets
#' @examples
#' data(cchs2007_2008)
#' str(cchs2007_2008)
NULL

#' 2009-2010 CCHS data
#'
#' This is a subset of 200 observations from the 2009-2010 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: CCHS-82M0013-E-2009-2010-Annualcomponent
#'
#' DDI: \url{https://osf.io/ynzpe/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2009_2010
#' @aliases cchs2009_2010
#' @docType data
#' @return \item{cchs2009_2010}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=67251}
#'
#' @keywords datasets
#' @examples
#' data(cchs2009_2010)
#' str(cchs2009_2010)
NULL

#' 2010 CCHS data
#'
#' This is a subset of 200 observations from the 2010 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: CCHS-82M0013-E-2010-AnnualComponent
#'
#' DDI: \url{https://osf.io/7stpz/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2010
#' @aliases cchs2010
#' @docType data
#' @return \item{cchs2010}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=81424}
#'
#' @keywords datasets
#' @examples
#' data(cchs2010)
#' str(cchs2010)
NULL

#' 2011-2012 CCHS data
#'
#' This is a subset of 200 observations from the 2011-2012 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#'
#' Long name: cchs-82M0013-E-2011-2012-Annual-component
#'
#' DDI: \url{https://osf.io/zk2vw/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2011_2012
#' @aliases cchs2011_2012
#' @docType data
#' @return \item{cchs2011_2012}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=114112}
#'
#' @keywords datasets
#' @examples
#' data(cchs2011_2012)
#' str(cchs2011_2012)
NULL

#' 2012 CCHS data
#'
#' This is a subset of 200 observations from the 2012 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: cchs-82M0013-E-2012-Annual-component
#'
#' DDI: \url{https://osf.io/sbem8/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2012
#' @aliases cchs2012
#' @docType data
#' @return \item{cchs2012}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=135927}
#'
#' @keywords datasets
#' @examples
#' data(cchs2012)
#' str(cchs2012)
NULL

#' 2013-2014 CCHS data
#'
#' This is a subset of 200 observations from the 2013-2014 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: cchs-82M0013-E-2013-2014-Annual-component
#'
#' DDI: \url{https://osf.io/gy25d/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2013_2014
#' @aliases cchs2013_2014
#' @docType data
#' @return \item{cchs2013_2014}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=144170}
#'
#' @keywords datasets
#' @examples
#' data(cchs2013_2014)
#' str(cchs2013_2014)
NULL

#' 2014 CCHS data
#'
#' This is a subset of 200 observations from the 2014 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license.
#'
#' Long name: cchs-82M0013-E-2014-Annual-component
#'
#' DDI: \url{https://osf.io/tbmdn/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2014
#' @aliases cchs2014
#' @docType data
#' @return \item{cchs2014}{a data frame}
#'
#' @source
#'  \url{http://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=164081}
#'
#' @keywords datasets
#' @examples
#' data(cchs2014)
#' str(cchs2014)
NULL
