% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_image_batch}
\alias{get_chemical_image_batch}
\title{Get image file by DTXSID or DTXCID batch}
\usage{
get_chemical_image_batch(
  DTXSID = NULL,
  DTXCID = NULL,
  format = "",
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of chemical identifier DTXSIDs.}

\item{DTXCID}{A list of chemical identifier DTXCIDs.}

\item{format}{The image type, either "png" or "svg". If left blank, will
default to "png".}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of Large arrays of three dimensions representing an image. For
displaying an image, one may use \code{png::writePNG()} or
\code{countcolors::plotArrayAsImage()} among many such functions.
}
\description{
Get image file by DTXSID or DTXCID batch
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull images for multiple chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
images <- get_chemical_image_batch(DTXSID = dtxsid)
if (requireNamespace("countcolors", quietly = TRUE)){
  countcolors::plotArrayAsImage(images[[1]])
  countcolors::plotArrayAsImage(images[[2]])
}
\dontshow{\}) # examplesIf}
}
