% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_data_fetch.R
\name{cc_data_fetch}
\alias{cc_data_fetch}
\title{Download CCAFS data}
\usage{
cc_data_fetch(key, overwrite = FALSE, ...)
}
\arguments{
\item{key}{(character) a character string specifying a S3 key
or a URL (the output from a call to \code{\link[=cc_search]{cc_search()}}. the key
can have spaces and newlines, which are removed internally - this allows
keys to break across lines as keys can be very long}

\item{overwrite}{(logical) Whether to overwrite files if they already
exist on your machine. Default: \code{FALSE}}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
A character vector of full file paths. A print method makes a tidy
return object in an S3 class.
}
\description{
Download CCAFS data
}
\details{
Note that data is not read into R as data can be very large.
See \code{\link[=cc_data_read]{cc_data_read()}}

Look in \code{rappdirs::user_cache_dir("ccafs")} for what files are
cached and to delete any.

Note that we've made it so that you can index into the return object,
getting either one or many results and the S3 class will be retained,
so that you can pass the result down to \code{\link[=cc_data_read]{cc_data_read()}}
}
\examples{
\dontrun{
key <- "ccafs/ccafs-climate/data/ipcc_5ar_ciat_downscaled/rcp2_6/
 2030s/bcc_csm1_1_m/10min/
 bcc_csm1_1_m_rcp2_6_2030s_prec_10min_r1i1p1_no_tile_asc.zip"

(res <- cc_data_fetch(key = key))
# indexing maintains class for easier subsetting
res[1]
res[[1]]
res[1:2]

res <- cc_list_keys()
zips <- grep("\\\\.zip", res$Key, value = TRUE)
x <- cc_data_fetch(zips[1])
unclass(x)
cc_data_read(x[1])
cc_data_read(x[1:3])
cc_data_read(x)

library(raster)
plot(cc_data_read(x[1]))
plot(cc_data_read(x[1:3]))
}
}
