% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{cbc_decode}
\alias{cbc_decode}
\title{Convert dummy-coded CBC data back to categorical format}
\usage{
cbc_decode(data)
}
\arguments{
\item{data}{A \code{cbc_design} or \code{cbc_choices} object with dummy-coded categorical variables}
}
\value{
The input object with categorical variables restored to their original format
}
\description{
This function converts dummy-coded CBC designs or choice data back to their original
categorical format. This is useful for displaying choice questions to
respondents or for analysis that requires categorical variables. Only
works for data without no-choice options, as no-choice data cannot
be meaningfully converted back to categorical format.
}
\examples{
library(cbcTools)

# Create profiles with categorical variables
profiles <- cbc_profiles(
  price = c(10, 20, 30),
  quality = c("Low", "Medium", "High"),
  brand = c("A", "B")
)

# Create design (will be dummy-coded by default)
design <- cbc_design(
  profiles = profiles,
  n_alts = 2,
  n_q = 4
)

# Convert design back to categorical format
design_categorical <- cbc_decode(design)
head(design_categorical)

# Also works with choice data
choices <- cbc_choices(design)
choices_categorical <- cbc_decode(choices)
head(choices_categorical)
}
