% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{posteriorDensityIncrement}
\alias{posteriorDensityIncrement}
\title{Posterior density of an increment}
\usage{
posteriorDensityIncrement(
  node,
  vals,
  tree,
  tipTrait,
  root.value = NULL,
  disp,
  method = c("reml", "random.root", "fixed.root")
)
}
\arguments{
\item{node}{the node ending the branch for which to compute the posterior density of the increment.}

\item{vals}{the table of values where the density should be computed.}

\item{tree}{a phylogenetic tree of class \code{\link[ape]{phylo}}.}

\item{tipTrait}{a names vector of tip trait values, with names matching the tree labels.}

\item{root.value}{the root starting value of the process.}

\item{disp}{the dispersion value.}

\item{method}{the method used to compute the likelihood.
One of \code{reml} (the default), \code{fixed.root} or \code{random.root}.
See Details.}
}
\value{
the posterior density value.
}
\description{
Compute the posterior density of a set of branch increments under a Cauchy process on a phylogenetic tree.
}
\details{
This function is internally called by \code{\link{increment}}, which
is the preferred way of doing ancestral reconstruction on a fitted
object.
}
\examples{
set.seed(1289)
phy <- ape::rphylo(5, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy", parameters = list(root.value = 0, disp = 1))
posteriorDensityIncrement(2, 0.1, phy, dat, disp = 1)


}
\seealso{
\code{\link{increment}}, \code{\link{fitCauchy}}
}
