% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catsim.R
\name{catsim}
\alias{catsim}
\title{Multiscale Categorical Structural Similarity Index Measure}
\usage{
catsim(
  x,
  y,
  ...,
  cube = TRUE,
  levels = NULL,
  weights = NULL,
  method = "Cohen",
  window = NULL
)
}
\arguments{
\item{x, y}{a binary or categorical image}

\item{...}{additional arguments, such as window, can be passed
as well as arguments for internal functions.}

\item{cube}{for the 3D method, whether to use the true 3D method
(cube or \code{\link[=catmssim_3d_cube]{catmssim_3d_cube()}})
or compute the metric using 2D slices which are then averaged
(\code{\link[=catmssim_3d_slice]{catmssim_3d_slice()}}). By default, \code{TRUE},
which evaluates as a cube. \code{FALSE} will treat it as
2D slices.}

\item{levels}{how many levels of downsampling to use. By default, 5. If
\code{weights} is specified and this is left blank, the argument
will be inferred from the number of weights specified.}

\item{weights}{a vector of weights for the different scales. By default,
equal to \code{rep(1,levels)/levels}. If specified, there must
at least as many  weights as there are levels and the first
\code{levels} weights will be used.}

\item{method}{whether to use Cohen's kappa (\code{Cohen}),
Jaccard Index (\code{Jaccard}), Dice index (\code{Dice}),
accuracy (\code{accuracy}),  Rand index (\code{Rand}),
Adjusted Rand Index (\code{AdjRand} or \code{ARI}), normalized mutual
information (\code{NMI} or \code{MI}), or adjusted mutual information
(\code{AMI}) as the similarity index.
Note Jaccard and Dice should only be used on binary data.}

\item{window}{by default 11 for 2D and 5 for 3D images, but can be
specified as a vector if the window sizes differ by dimension.
The vector must have the same number of
dimensions as the inputted \code{x} and \code{y}.}
}
\value{
a value less than 1 indicating the similarity between the images.
}
\description{
The categorical structural similarity index measure for 2D or 3D categorical or
binary images for multiple scales. The default is to compute over 5 scales.
This determines whether this is a 2D or 3D image and applies the appropriate
windowing, weighting, and scaling. Additional arguments can be passed.
This is a wrapper function for the 2D and 3D functions whose functionality
can be accessed through the ... arguments. This function is a wrapper for the
\code{\link[=catmssim_2d]{catmssim_2d()}}, \code{\link[=catmssim_3d_slice]{catmssim_3d_slice()}}, and
\code{\link[=catmssim_3d_cube]{catmssim_3d_cube()}}
functions.
}
\examples{
set.seed(20181207)
dim <- 16
x <- array(sample(0:4, dim^3, replace = TRUE), dim = c(dim, dim, dim))
y <- x
for (j in 1:dim) {
  for (i in 1:dim) y[i, i, j] <- 0
  for (i in 1:(dim - 1)) y[i, i + 1, j] <- 0
}
catsim(x, y, weights = c(.75, .25))
# Now using a different similarity score
catsim(x, y, levels = 2, method = "accuracy")
# with the slice method:
catsim(x, y, weights = c(.75, .25), cube = FALSE, window = 8)
}
