% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQualtrics.R
\name{readQualtrics}
\alias{readQualtrics}
\alias{readQualtrics,character-method}
\title{Clean adaptive inventory responses from Qualtrics}
\usage{
\S4method{readQualtrics}{character}(catObj, responseID)
}
\arguments{
\item{catObj}{Vector containing JSON character representations of the completed Cat objects from Qualtrics survey}

\item{responseID}{Vector containing unique character identifiers for the respondents in the Qualtrics survey}
}
\value{
This function returns a data frame containing cleaned adaptive inventory responses.
}
\description{
This function cleans the adaptive inventory responses stored as embedded data in Qualtrics
}
\details{
This function cleans the adaptive inventory responses contained in the Qualtrics survey
results.  Because different respondents recieve different adaptive inventories, 
their answers to the battery are not stored as usual as separate columns in the Data & Analysis tab 
in the Qualtrics toolbar.  Rather, the respondents' answers to the adaptive battery are saved in 
the catObj embedded data object.  To access the answers, click "Export & Import", and then "Export Data."
In the window that appears, we recommend downloading the data as a .csv file.
Then, feed this function the catObj column and the responseID column.
}
\examples{

\dontrun{
raw_df <- read.csv("qualtrics_results.csv", stringsAsFactors = FALSE)

# removing first two header rows containing question text and import ID
clean_df <- readQualtrics(raw_df$catObj[-c(1,2)], raw_df$catObj[-c(1,2)])
}

}
\seealso{
\code{\link{Cat-class}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
