% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPencilLayer.R
\name{getPencilLayer}
\alias{getPencilLayer}
\title{Pencil Layer}
\usage{
getPencilLayer(x, size = 100, buffer = 1000, lefthanded = TRUE)
}
\arguments{
\item{x}{an sf object, a simple feature collection (POLYGON or MULTIPOLYGON).}

\item{size}{density of the penciling. Median number of points used to build 
the MULTILINESTRING.}

\item{buffer}{buffer around each polygon. This buffer (in map units) is used 
to take sample points. A negative value adds a margin between the penciling 
and the original polygons borders}

\item{lefthanded}{if TRUE the penciling is done left-handed style.}
}
\value{
A MULTILINESTRING sf object is returned.
}
\description{
Create a pencil layer. This function transforms a POLYGON or 
MULTIPOLYGON sf object into a MULTILINESTRING one.
}
\examples{
library(sf)
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
mtq_pencil <- getPencilLayer(x = mtq)
plot(st_geometry(mtq_pencil), col = 1:8)
plot(st_geometry(mtq), add = TRUE)

typoLayer(x = mtq_pencil, var="STATUT", add = FALSE,
          col = c("aquamarine4", "yellow3","wheat"),
          legend.values.order = c("Préfecture de région",
                                  "Sous-préfecture", 
                                  "Commune simple"),
          legend.pos = "topright",
          legend.title.txt = "Status")
plot(st_geometry(mtq), add = TRUE, ldy=2)
layoutLayer(title = "Commune Status",
            author = "UMS RIATE, 2017",
            sources = "IGN, 2016",
            scale = NULL)
}
