% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowreduct.R
\name{flowreduct}
\alias{flowreduct}
\title{Flow matrice reduction according to another matrix}
\usage{
flowreduct(tab, tab.metric, metric, select, d)
}
\arguments{
\item{tab}{is the input flowdata set.}

\item{tab.metric}{is the table of distance (continuous dataset) or contiguity (ordinal dataset)}

\item{metric}{See Details.}

\item{select}{is the continuous distance thresholding parameter. See Details.}

\item{d}{distance thresholds criterion.}
}
\value{
A flow dataset with continuous euclidian distances calculations
}
\description{
Reduces a flow dataset according to an external matrix (eg. distance travelled)
Computes geographical movements (by weighting a flow dataset according to a distance criterion)
}
\details{
-- Metric is 'continous" for distance as euclidian, maximum, manhattan, etc.\cr
See \link{flowdist} for computing neighbourhood ordinal distance matrix.

select ="dmin" for reducing flow dataset to values that are up or equal to the dmin distance parameter ;\cr
select ="dmax" for reducing flow dataset to values that are less or equal to the dmax distance.

-- Metric is 'ordinal' for neighbourhood ordinal distance so-called k contiguity.\cr
See \link{flowcontig} for computing continuous distance matrix
}
\examples{
library(cartograflow)
data(flowdata)
bkg<- system.file("shape/MGP_TER.shp", package="cartograflow",
                  lib.loc = NULL, mustWork = TRUE)
tab<-flowjointure(flows,bkg,"EPT_NUM")

#Example for reducing a flow matrice with a distance matrice, in long format (i,j, distance)
##1/2: Computes the matrice distances
tab.distance<-flowdist(tab, dist.method = "euclidian",result = "dist")
##2/2: Reduce the flow matrice
tab.flow<-flowreduct(tab,tab.distance, metric = "continous",
                     select = "dmax", #maximum distance travelled criterion
                     d = 8567) #maximum distance value
}
