% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_conformal.R
\name{predict.conformalRegressorByHorizon}
\alias{predict.conformalRegressorByHorizon}
\title{Predict intervals from a horizon-specific conformal regressor}
\usage{
\method{predict}{conformalRegressorByHorizon}(
  object,
  y_hat = NULL,
  confidence = 0.95,
  y_min = -Inf,
  y_max = Inf,
  ...
)
}
\arguments{
\item{object}{A conformalRegressorByHorizon object}

\item{y_hat}{Predicted values (one per horizon)}

\item{confidence}{Confidence level(s) between 0 and 1 (e.g., 0.95 for 95 percent)}

\item{y_min}{The minimum value to include in prediction intervals}

\item{y_max}{The maximum value to include in prediction intervals}

\item{...}{Ignored}
}
\value{
A data frame with lower and upper bounds for each confidence level
}
\description{
This function generates prediction intervals that account for increasing
uncertainty at longer forecast horizons. Each horizon h uses its own
calibrated nonconformity score distribution, resulting in trumpet-shaped
prediction intervals.
}
\author{
Resul Akay
}
