% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous.R
\name{.check_no_ard_columns}
\alias{.check_no_ard_columns}
\title{Check Protected Column Names}
\usage{
.check_no_ard_columns(x, exceptions = "...ard_dummy_for_counting...")
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}

\item{exceptions}{(\code{string})\cr
character string of column names to exclude from checks}
}
\value{
returns invisible if check is successful, throws an error message if not.
}
\description{
Checks that column names in a passed data frame are not protected, that is,
they do not begin with \code{"...ard_"} and end with \code{"..."}.
}
\examples{
data <- data.frame("ard_x" = 1)

cards:::.check_no_ard_columns(data)
}
\keyword{internal}
