% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circadian-patterns.R
\name{circ_odds}
\alias{circ_odds}
\title{Odds Ratio Table by Time Point}
\usage{
circ_odds(data, time, outcome, covar)
}
\arguments{
\item{data}{Dataframe containing subsequent columns}

\item{time}{Column name that contains the grouping variable of time}

\item{outcome}{Column name that identifies the per-row outcome,
binary}

\item{covar}{Vector of independent variables names. First
variable needs to be exposure.}
}
\value{
A data frame of odds ratios
}
\description{
Creates an OR table for each time point of data given, initially
applied to any grouping variable (particularly hour/time of day).
}
\details{
This function creates an OR table based on the covariate
names supplied. It requires that there is an appropriate outcome
variable selected. It performs a logistic regression. This model
does not allow for conditioning variables (yet).
}
\examples{
# Data
data(twins)

# Create odds ratio tables by hour of day for covariate of interest
ot <- circ_odds(twins, "hour", "sad_bin", "rDYX")

}
