% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_table.R
\name{summary_table}
\alias{summary_table}
\title{Generate formatted regression tables}
\usage{
summary_table(
  ...,
  coef_digits = 3,
  se_digits = 3,
  stars = TRUE,
  latex = FALSE,
  model_names = NULL
)
}
\arguments{
\item{...}{One or more model objects of \code{felm} or \code{feglm} class.}

\item{coef_digits}{Number of digits for coefficients. The default is 3.}

\item{se_digits}{Number of digits for standard errors. The default is 3.}

\item{stars}{Whether to include significance stars. The default is \code{TRUE}.}

\item{latex}{Whether to output as LaTeX code. The default is \code{FALSE}.}

\item{model_names}{Optional vector of custom model names}
}
\value{
A formatted table
}
\description{
Generate formatted regression tables
}
\examples{
m1 <- felm(mpg ~ wt | cyl, mtcars)
m2 <- fepoisson(mpg ~ wt | cyl, mtcars)
summary_table(m1, m2, model_names = c("Linear", "Poisson"))
}
